#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TestingWorklist : BaseTest 
	{
		private BOL.TestingWorklist _testingWorklist;
		private BOL.TestingWorklist _patientTestingWorklist;
		private BOL.TestingWorklist _testingWorklistFuture;

		private Guid _patientGuid;
		private Guid _patientSpecimenGuid;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

		    Hashtable myGuids = DataCreator.CreateCrossmatchedBloodUnitTestData();
            Guid patientGuid = (Guid)myGuids["patientGuid"];
			string sSQL = "SELECT TOP 1 * FROM SpecimenTest ";
			sSQL +=	"JOIN PatientSpecimen ON SpecimenTest.PatientSpecimenGuid = PatientSpecimen.PatientSpecimenGuid ";
			sSQL += "JOIN Patient ON PatientSpecimen.PatientGuid = Patient.PatientGuid ";
			sSQL += "JOIN BloodTestType ON SpecimenTest.BloodTestTypeId = BloodTestType.BloodTestTypeId ";
		    sSQL += "JOIN OrderedTest ON SpecimenTest.OrderedTestGuid = OrderedTest.OrderedTestGuid AND OrderedTest.OrderableTestId IS NOT NULL ";
			sSQL += "WHERE PatientSpecimen.PatientSpecimenGuid IS NOT NULL ";
			sSQL += "AND BloodTestType.BloodTestName LIKE '%Interp' ";
            sSQL += "AND SpecimenTest.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND Patient.PatientGuid = '" + patientGuid.ToString() + "'";

			DataTable dtSpecimenData = UnitTestUtil.RunSQLGetDataTable(sSQL);

			_patientGuid			= (System.Guid) dtSpecimenData.Rows[0][TABLES.Patient.PatientGuid];
			_patientSpecimenGuid	= (System.Guid) dtSpecimenData.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			BOL.Patient patient = new BOL.Patient(_patientGuid);
			ArrayList specimens = new ArrayList();
			specimens.Add(new BOL.Specimen(_patientSpecimenGuid));

			_testingWorklist = new BOL.TestingWorklist();
			_testingWorklist.StartDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-365);
			_testingWorklist.EndDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			_testingWorklist.SetInitialBrokenRules("DlgTestingWorklistCriteria");
			//
			_testingWorklistFuture = new BOL.TestingWorklist();
			_testingWorklistFuture.StartDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays(1);
			_testingWorklistFuture.EndDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays(365);
			//
			_patientTestingWorklist = new BOL.TestingWorklist(patient, specimens);
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!_testingWorklist.Equals(null));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_Patient_ArrayList_Pass()
		{
			Assert.IsTrue(!_patientTestingWorklist.Equals(null));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Patient_ArrayList_Fail()
		{
		}

		[Test]
		public void TestTestingWorklist_IncludePatientTesting_Get()
		{
			Assert.IsTrue(!_testingWorklist.IncludePatientTesting);
			Assert.IsTrue(_patientTestingWorklist.IncludePatientTesting);
		}

		[Test]
		public void TestTestingWorklist_IncludePatientTesting_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._testingWorklist.BrokenRulesCount;
			this._testingWorklist.IncludePatientTesting = true;
			brokenRulesAfter=this._testingWorklist.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTestingWorklist_IncludePatientTesting_Fail()
		{
		}

		[Test]
		public void TestTestingWorklist_IncludeUnitTesting_Get()
		{
			Assert.IsTrue(!_testingWorklist.IncludeUnitTesting);
		}

		[Test]
		public void TestTestingWorklist_IncludeUnitTesting_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._testingWorklist.BrokenRulesCount;
			this._testingWorklist.IncludeUnitTesting = true;
			brokenRulesAfter=this._testingWorklist.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTestingWorklist_IncludeUnitTesting_Fail()
		{
		}

		[Test]
		public void TestTestingWorklist_IncludeRackTesting_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._testingWorklist.BrokenRulesCount;
			this._testingWorklist.IncludeRackTesting = true;
			brokenRulesAfter=this._testingWorklist.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTestingWorklist_IncludeRackTesting_Fail()
		{
		}

		[Test]
		public void TestTestingWorklist_IncludeReagentTesting_Get()
		{
			bool tstValue = this._testingWorklist.IncludeReagentTesting;

			Assert.AreEqual(this._testingWorklist.IncludeReagentTesting, tstValue);
		}

		[Test]
		public void TestTestingWorklist_IncludeReagentTesting_Pass()
		{
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=this._testingWorklist.BrokenRulesCount;
			this._testingWorklist.IncludeReagentTesting = true;
			brokenRulesAfter=this._testingWorklist.BrokenRulesCount;
			Assert.IsTrue(brokenRulesAfter<brokenRulesBefore);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTestingWorklist_IncludeReagentTesting_Fail()
		{
		}

		[Test]
		public void TestTestingWorklist_Patient_Get()
		{
			Assert.IsNull(_testingWorklist.Patient);
			Assert.IsNotNull(_patientTestingWorklist.Patient);
		}

		[Test]
		public void TestTestingWorklist_Patient_Pass()
		{
			this._testingWorklist.Patient = new BOL.Patient(_patientGuid);
			Assert.IsNotNull(_testingWorklist.Patient);
			Assert.IsTrue(_testingWorklist.IncludePatientTesting);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_Patient_Fail()
		{
			this._testingWorklist.Patient = new BOL.Patient();
			Assert.IsNotNull(_testingWorklist.Patient);
		}

		[Test]
		public void TestTestingWorklist_Specimens_Get()
		{
			Assert.IsNull(_testingWorklist.Specimens);
			Assert.IsNotNull(_patientTestingWorklist.Specimens);
		}

		[Test]
		public void TestTestingWorklist_Specimens_Pass()
		{
			ArrayList specimens = new ArrayList();
			specimens.Add(new BOL.Specimen(_patientSpecimenGuid));
			this._testingWorklist.Specimens = specimens;
			Assert.IsNotNull(_testingWorklist.Specimens);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_Specimens_Fail()
		{
			ArrayList specimens = new ArrayList();
			specimens.Add(new BOL.Patient(_patientGuid));
			this._testingWorklist.Specimens = specimens;
			Assert.IsNotNull(_testingWorklist.Specimens);
		}

		[Test]
		public void TestTestingWorklist_ReportCriteria_Get()
		{
			Assert.IsTrue(_testingWorklist.ReportCriteria.StartsWith("Date Range"));
			Assert.IsTrue(_patientTestingWorklist.ReportCriteria.StartsWith("Patient"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_ReportCriteria_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_PatientTestingWorklist_Get()
		{
			_testingWorklist.IncludePatientTesting = true;
			Assert.IsTrue(_testingWorklist.PatientTestingWorklist.Rows.Count>0);
			Assert.IsTrue(_patientTestingWorklist.PatientTestingWorklist.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_PatientTestingWorklist_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_UnitTestingWorklist_Get()
		{
			_testingWorklist.IncludeUnitTesting = true;
			Assert.IsTrue(_testingWorklist.UnitTestingWorklist.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_UnitTestingWorklist_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_RackTestingWorklist_Get()
		{
			_testingWorklist.IncludeRackTesting = true;
			Assert.IsTrue(_testingWorklist.RackTestingWorklist.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_RackTestingWorklist_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_ReagentTestingWorklist_Get()
		{
			_testingWorklist.IncludeReagentTesting = true;
			Assert.IsTrue(_testingWorklist.ReagentTestingWorklist.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_ReagentTestingWorklist_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_ReportSectionsTable_Get()
		{
			Assert.AreEqual(1,_testingWorklist.ReportSectionsTable.Rows.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TestTestingWorklist_ReportSectionsTable_Pass()
		{
		}

		[Test]
		public void TestTestingWorklist_GetTestingWorklistCount_Pass()
		{
			_testingWorklist.IncludePatientTesting = true;
			_testingWorklist.IncludeUnitTesting = true;
			_testingWorklist.IncludeReagentTesting = true;
			_testingWorklist.IncludeRackTesting = true;
			Assert.IsTrue(_testingWorklist.GetTestingWorklistCount()>0);
		}

		[Test]
		public void TestTestingWorklist_GetTestingWorklistCount_Fail()
		{
			Assert.IsTrue(_testingWorklist.GetTestingWorklistCount()==0);
		}

		[Test]
		public void TestTestingWorklist_GetTestingWorklist_Pass()
		{
			_testingWorklist.IncludePatientTesting = true;
			_testingWorklist.IncludeUnitTesting = true;
			_testingWorklist.IncludeReagentTesting = true;
			_testingWorklist.IncludeRackTesting = true;
			//
			_testingWorklist.GetTestingWorklist();
			//
			Assert.IsNotNull(_testingWorklist.PatientTestingWorklist);
			Assert.IsNotNull(_testingWorklist.UnitTestingWorklist);
			Assert.IsNotNull(_testingWorklist.RackTestingWorklist);
			Assert.IsNotNull(_testingWorklist.ReagentTestingWorklist);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_GetTestingWorklist_Fail()
		{
			_testingWorklist.GetTestingWorklist();
			//
			Assert.IsNull(_testingWorklist.PatientTestingWorklist);
			Assert.IsNull(_testingWorklist.UnitTestingWorklist);
			Assert.IsNull(_testingWorklist.RackTestingWorklist);
			Assert.IsNull(_testingWorklist.ReagentTestingWorklist);
		}

		[Test]
		public void TestTestingWorklist_GetPatientTestingWorklistByDates_Pass()
		{
			_testingWorklist.IncludePatientTesting = true;
			_testingWorklist.GetPatientTestingWorklist();
			Assert.IsTrue(_testingWorklist.PatientTestingWorklist.Rows.Count>0);
		}

		[Test]
		public void TestTestingWorklist_GetPatientTestingWorklistByPatient_Pass()
		{
			_patientTestingWorklist.GetPatientTestingWorklist();
			Assert.IsTrue(_patientTestingWorklist.PatientTestingWorklist.Rows.Count>0);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_GetPatientTestingWorklist_Fail()
		{
			_testingWorklist.GetPatientTestingWorklist();
			Assert.IsTrue(_testingWorklistFuture.PatientTestingWorklist.Rows.Count==0);
		}

		[Test]
		public void TestTestingWorklist_GetBloodUnitTestingWorklist_Pass()
		{
			_testingWorklist.IncludeUnitTesting = true;
			_testingWorklist.GetBloodUnitTestingWorklist();
			Assert.IsTrue(_testingWorklist.UnitTestingWorklist.Rows.Count>0);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_GetBloodUnitTestingWorklist_Fail()
		{
			_testingWorklist.GetBloodUnitTestingWorklist();
			Assert.IsTrue(_testingWorklist.UnitTestingWorklist.Rows.Count==0);
		}

		[Test]
		public void TestTestingWorklist_GetRackQCTestingWorklist_Pass()
		{
			_testingWorklist.IncludeRackTesting = true;
			_testingWorklist.GetRackQCTestingWorklist();
			Assert.IsTrue(_testingWorklist.RackTestingWorklist.Rows.Count>0);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_GetRackQCTestingWorklist_Fail()
		{
			_testingWorklist.GetRackQCTestingWorklist();
			Assert.IsTrue(_testingWorklist.RackTestingWorklist.Rows.Count==0);
		}

		[Test]
		public void TestTestingWorklist_GetReagentQCTestingWorklist_Pass()
		{
			_testingWorklist.IncludeReagentTesting = true;
			_testingWorklist.GetReagentQCTestingWorklist();
			Assert.IsTrue(_testingWorklist.ReagentTestingWorklist.Rows.Count>0);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void TestTestingWorklist_GetReagentQCTestingWorklist_Fail()
		{
			_testingWorklist.GetReagentQCTestingWorklist();
			Assert.IsTrue(_testingWorklist.ReagentTestingWorklist.Rows.Count==0);
		}

		/*[Test]
		public void TestTestingWorklist_GenerateReport_Pass()
		{
			gov.va.med.vbecs.reports.TestingWorklist.TestingWorklistMain mainReport = 
				_testingWorklist.GenerateReport( UnitTestConfig.User_AdministratorSupervisor );  
			//
			Assert.IsNotNull( mainReport );
		}*/

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestTestingWorklist_GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void TestTestingWorklist_GenerateAndPrintReport_Pass()
		{
			//Sends report directly to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void TestTestingWorklist_GenerateAndPrintReport_Fail()
		{
			//Sends report directly to printer
		}
	}
}
#endif
